//inc file for putting stuff into boxes in pile formations
//by tek


/*
m_PileOfStuffInABox

Creates a pile of objects randomly selected from a given array.
Uses trace() function to position objects so that they are touching each other.
keeps creating objects until the box overflows (overflowed objects are culled).

parameters:
vBoxDimensions -
	the box. it will be positioned centred on <0,0,0>.
	(e.g. a box of size <2,2,2> will be box { <-1,-1,-1>, <1,1,1> }
aoStuffObjects -
	array of objects, these nay be any shape but the system is designed for roughly spherical ones.
	they should be centred on <0,0,0>
nStuffArraySize -
	size of the array
fBiggestStuffRadius -
	a radius big enough to completely contain any object in the array.

usage:

#declare aObjects = array [2];
#declare aObjects[0] = sphere { 0, .5 }
#declare aObjects[1] = sphere { 0, 1 }

#declare Pile =
	object {
		m_PileOfStuffInABox( <3,2,5>, aObjects, 2, 1 )
	}

union {
	object { Pile }
	difference {
		box { -.5, .5 scale <3,2,5>+.1 }
		box { -.5, .5+y scale <3,2,5> }
	}
}
*/

#declare rsPileOfStuff = seed(13);

#macro m_PileOfStuffInABox( vBoxDimensions, aoStuffObjects, nStuffArraySize, fBiggestStuffRadius )

	#local nExtentTestRays = 40;
	#local nLowPointTestRays = 40;

	/*
	sphere model
	will collide along planes
	
	th. could work out dist by tracing grid normal to plane on intersection of the two objects.

	*or*
	th. represent current situation as a "height field".
		form inverse height_field of bottom of this object.
		find the lowest place to put it! - with additional rule to not put it somewhere it can roll off.
		(poss at many orientations, then pick best one)
		
	*or*
	cellular automaton. each particle gets created, and then moves in steps using rules.
	each move does a test using trace to assess if it's going to bump into stuff.
	*/
	
//	#local nGridResolutionPerUnit = 10;
//	#local aHeightField = array[(vBoxDimensions.x * nGridResolutionPerUnit)][(vBoxDimensions.z * nGridResolutionPerUnit)];
	#local oTestPile = plane { y, 0 } //base
	#local oPile = sphere { 0, 0 } //dummy

	#local boOverFlowed = false;
	#local nDebug = 0;	
	#while ( !boOverFlowed & nDebug < 500 )
	
		//pick object
		#local nObject = int((nStuffArraySize-.001)*rand(rsPileOfStuff));
		#local oObject =
			object {
				aoStuffObjects[nObject]
				rotate <90,360,0> * <pow(rand(rsPileOfStuff)*2-1,2), rand(rsPileOfStuff), 0>
			}
			
		//bound the object
		#local vObjectMax = <-fBiggestStuffRadius,-fBiggestStuffRadius,-fBiggestStuffRadius>;
		#local vObjectMin = <fBiggestStuffRadius,fBiggestStuffRadius,fBiggestStuffRadius>;
		#local nSide = 0;
		#while (nSide < 4)
			#local vDir = vrotate( z, nSide*90*y );
			
			#local nPos = 0;
			#while ( nPos < nExtentTestRays )

				#local vPos = vrotate( z + x*nPos/nExtentTestRays, nPos*sqrt(nExtentTestRays)*360*z );
				#local vPos = fBiggestStuffRadius * vrotate( vPos, nSide*90*y );
				#local vPos = trace( oObject, vPos, -vDir );
				
				#switch (nSide)
					#case (0)
						#if ( vPos.z > vObjectMax.z )
							#local vObjectMax = vObjectMax*<1,1,0> + vPos.z*z;
						#end
						#break

					#case (1)
						#if ( vPos.x > vObjectMax.x )
							#local vObjectMax = vObjectMax*<0,1,1> + vPos.x*x;
						#end
						#break

					#case (2)
						#if ( vPos.z < vObjectMin.z )
							#local vObjectMin = vObjectMin*<1,1,0> + vPos.z*z;
						#end
						#break

					#case (3)
						#if ( vPos.x < vObjectMin.x )
							#local vObjectMin = vObjectMin*<0,1,1> + vPos.x*x;
						#end
						#break
				#end//switch
				
				#local nPos = nPos + 1;
			#end //while (test ray)
			
			#local nSide = nSide + 1;
		#end //while (side)
	
		//find best point on current height field
		#local vPos = (fBiggestStuffRadius*2 + vBoxDimensions.y/2 + vBoxDimensions.x/2)*y;
		#local nPos = 0;
		#while (nPos < nLowPointTestRays)
			#local vTest = <rand(rsPileOfStuff),0,rand(rsPileOfStuff)>*(vBoxDimensions-vObjectMax+vObjectMin) - <1,0,1>*vBoxDimensions/2 - vObjectMin;
			#local vTest = trace( oTestPile, vTest + (fBiggestStuffRadius*2 + vBoxDimensions.y/2 + vBoxDimensions.x/2)*y, -y );
			
			#if ( vTest.y < vPos.y )
				#local vPos = vTest;
			#end
			
			#local nPos = nPos + 1;
		#end //while (test ray)
		
		//compute shift in position so objects touch but don't intersect.
		#local vShift = trace( oObject, -fBiggestStuffRadius*y, y );
		#local vPos = vPos - vShift.y*y;
				
		//put object there
	//	recalculate that area of height field
			#local oPile =
				union {
					object { oObject translate vPos }
					//box { vObjectMin, vObjectMax pigment{rgbt<1,0,0,.5>} translate vPos }
					oPile
				}
			#local oTestPile =
				union {
					plane { y, 0 } //base
					oPile
				}
		
		//test overflow
		#if ( vPos.y > vBoxDimensions.y/2-vShift.y )
			#local boOverFlowed = true;
		#end //created above box top

		#local nDebug = nDebug + 1;
		#debug concat("piling ", str(nDebug,0,0), "\n")
	
	#end //#while ( !boOverFlowed ) 

	//return the object
	object { oPile }
#end